import sys

def solve():
    data = sys.stdin.read().strip().split()
    n = int(data[0])
    a = [0] + list(map(int, data[1:]))  # 1-indeksirano

    # dp[i] – maksimalna dužina koju možemo zadržati ako pocnemo blok na poziciji i
    # best[i] – maksimum dp[j] za sve j >= i (najbolje rešenje od pozicije i naviše)
    dp = [0] * (n + 2)
    best = [0] * (n + 3)

    for i in range(n, 0, -1):
        # blok je moguc samo ako ima dovoljno elemenata do kraja
        if a[i] <= n - i:
            next_start = i + a[i] + 1
            dp[i] = (a[i] + 1) + best[next_start]
        else:
            dp[i] = -10**18  # nemoguce

        best[i] = max(dp[i], best[i + 1])

    kept = best[1]  # maksimalan broj elemenata koji ostaju
    deletions = n - kept
    print(deletions)

if __name__ == "__main__":
    solve()